/*
 * Wykorzystanie sekcji krytycznej do synchronizacji wtkw
 */
#include <windows.h>  
#include <stdio.h>  
#include <stdlib.h>  
#include <assert.h>  

#define MAXTRY 3  

CRITICAL_SECTION cs;          // dzielona na wszystkie wtki  
  
// gwny wtek programu  
void ThreadMain(char *name)  
{  
      int i;  

      for (i=0; i<MAXTRY; i++)  
      {  
            EnterCriticalSection(&cs);  

            /* prosz sprbowa te zamiast 
               powyszej linii napisa 

               while ( TryEnterCriticalSection(&cs)==FALSE )  
               {  
                  printf("%s, czekam na wejcie\n", name);   
                  Sleep(5); 
               }
              
               uwaga! - tylko na WinNT!
               jdro Windows 95 nie rozpozna 
               funkcji TryEnterCriticalSection
            */  

            printf("%s, jestem w sekcji krytycznej!\n", name);  
            Sleep(5);  
            LeaveCritcalSection(&cs);  

            printf("%s, wyszedem z sekcji krytycznej!\n", name);  
      }  

}  

// tworzy wtek potomny  

HANDLE CreateChild(char* name)  
{  
      HANDLE hThread; DWORD dwId;  
      hThread = CreateThread(NULL, 0, 
                (LPTHREAD_START_ROUTINE)ThreadMain, 
                (LPVOID)name, 0, &dwId);  

      assert(hThread!=NULL); return hThread;            
}  

int main(void)  
{  
      HANDLE hT[4]; 

      InitializeCriticalSection(&cs);  

      hT[0]=CreateChild("Jurek");  
      hT[1]=CreateChild("Ogrek");  
      hT[2]=CreateChild("Kiebasa");  
      hT[3]=CreateChild("Sznurek");  

      WaitForMultipleObjects(4, hT, TRUE, INFINITE);  

      CloseHandle(hT[0]);CloseHandle(hT[1]);  
      CloseHandle(hT[2]);CloseHandle(hT[3]);  

      DeleteCriticalSection(&cs);  

      return 0;  
}  
